/*
 * Decompiled with CFR 0.152.
 */
package itx.core.web.filter;

import itx.core.web.WebRequest;
import itx.core.web.filter.RequestFilter;
import java.util.ArrayList;
import java.util.List;
import jtbcore.exception.InvalidStateException;

public class RequestFilterList {
    protected WebRequest webRequest;
    protected List<RequestFilter> requestFilters = new ArrayList<RequestFilter>();
    protected int filterPos = -1;

    public WebRequest getWebRequest() {
        return this.webRequest;
    }

    public void setWebRequest(WebRequest webRequest) {
        this.webRequest = webRequest;
    }

    public void addFilter(RequestFilter rf) throws InvalidStateException {
        if (this.filterPos >= 0) {
            throw new InvalidStateException("Filter executing, unable to add extra filters");
        }
        this.requestFilters.add(rf);
    }

    public void execute(WebRequest req) throws Exception {
        this.setWebRequest(req);
        this.filterPos = -1;
        this.next();
    }

    public void next() throws Exception {
        ++this.filterPos;
        if (this.filterPos < this.requestFilters.size()) {
            RequestFilter rf = this.requestFilters.get(this.filterPos);
            rf.execute(this);
        }
    }
}

